/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.gravestones.gravestones;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_4208;
import net.minecraft.server.MinecraftServer;
import net.pneumono.gravestones.GravestonesConfig;
import net.pneumono.gravestones.api.GravestonesApi;
import net.pneumono.gravestones.block.TechnicalGravestoneBlock;
import net.pneumono.gravestones.block.TechnicalGravestoneBlockEntity;
import net.pneumono.gravestones.gravestones.GravestoneManager;
import net.pneumono.gravestones.gravestones.GravestoneTime;
import net.pneumono.gravestones.gravestones.enums.DecayTimeType;
import net.pneumono.gravestones.multiversion.VersionUtil;

public class GravestoneDecay
extends GravestoneManager {
    public static void timeDecayGravestone(class_1937 world, class_2338 pos, class_2680 state) {
        long timeUnit;
        TechnicalGravestoneBlockEntity entity;
        class_2586 blockEntity = world.method_8321(pos);
        if (!((Boolean)GravestonesConfig.DECAY_WITH_TIME.getValue()).booleanValue() || !(blockEntity instanceof TechnicalGravestoneBlockEntity) || (entity = (TechnicalGravestoneBlockEntity)blockEntity).getGraveOwner() == null) {
            return;
        }
        long difference = GravestonesConfig.DECAY_TIME_TYPE.getValue() == DecayTimeType.TICKS ? world.method_8510() - entity.getSpawnDateTicks() : (entity.getSpawnDateTime() != null ? GravestoneTime.getDifferenceInSeconds(GravestoneTime.READABLE.format(new Date()), entity.getSpawnDateTime()) * 20L : 0L);
        if (difference > (timeUnit = ((Long)GravestonesConfig.DECAY_TIME.getValue()).longValue()) * 3L) {
            entity.setAgeDamage(3);
        } else if (difference > timeUnit * 2L) {
            entity.setAgeDamage(2);
        } else if (difference > timeUnit) {
            entity.setAgeDamage(1);
        }
        GravestoneDecay.updateTotalGravestoneDamage(world, pos, state, entity);
    }

    protected static void deathDamageOldGravestones(MinecraftServer server, List<class_4208> oldGravePositions, class_4208 newPos) {
        if (!((Boolean)GravestonesConfig.DECAY_WITH_DEATHS.getValue()).booleanValue()) {
            return;
        }
        ArrayList<class_4208> checkedPositions = new ArrayList<class_4208>();
        checkedPositions.add(newPos);
        for (class_4208 oldPos : oldGravePositions) {
            if (checkedPositions.contains(oldPos)) continue;
            GravestoneDecay.incrementDeathDamage(server, oldPos);
            checkedPositions.add(oldPos);
        }
    }

    public static void incrementDeathDamage(MinecraftServer server, class_4208 globalPos) {
        TechnicalGravestoneBlockEntity entity;
        class_2586 class_25862;
        class_3218 world = server.method_3847(VersionUtil.getDimension(globalPos));
        class_2338 pos = VersionUtil.getPos(globalPos);
        if (world == null || !((class_25862 = world.method_8321(pos)) instanceof TechnicalGravestoneBlockEntity) || (entity = (TechnicalGravestoneBlockEntity)class_25862).getGraveOwner() == null) {
            return;
        }
        entity.setDeathDamage(entity.getDeathDamage() + 1);
        GravestoneDecay.updateTotalGravestoneDamage((class_1937)world, pos, world.method_8320(pos), entity);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void updateTotalGravestoneDamage(class_1937 world, class_2338 pos, class_2680 state, TechnicalGravestoneBlockEntity entity) {
        int totalDamage = entity.getTotalDamage();
        if (totalDamage == (Integer)state.method_11654((class_2769)TechnicalGravestoneBlock.DAMAGE)) {
            return;
        }
        if (totalDamage >= 3) {
            if (!GravestonesApi.shouldDecayAffectGameplay()) return;
            world.method_22352(pos, true);
        } else if (totalDamage >= 0) {
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)TechnicalGravestoneBlock.DAMAGE, (Comparable)Integer.valueOf(totalDamage)));
        }
        entity.method_5431();
    }
}

